﻿using System;
using System.Text;

namespace StringBuilderExamples
{
    class Program
    {
        static void Main(string[] args)
        {
            {
                // Listing 10-65. Pojemność (Capacity) a długość (Length).
                StringBuilder builder1 = new StringBuilder();
                StringBuilder builder2 = new StringBuilder(1024);

                Console.WriteLine(builder1.Capacity);
                Console.WriteLine(builder1.Length);

                Console.WriteLine(builder2.Capacity);
                Console.WriteLine(builder1.Length);
            }
            Console.WriteLine();
            {
                // Listing 10-66. Sprawdzanie pojemności.
                StringBuilder builder1 = new StringBuilder();
                StringBuilder builder2 = new StringBuilder(1024);

                Console.WriteLine(builder1.Capacity);
                Console.WriteLine(builder1.Length);
                Console.WriteLine(builder2.Capacity);
                Console.WriteLine(builder2.Length);

                builder1.Append('A', 24);
                builder2.Append('A', 24);

                Console.WriteLine(builder1.Capacity);
                Console.WriteLine(builder1.Length);
                Console.WriteLine(builder2.Capacity);
                Console.WriteLine(builder2.Length);


                Console.WriteLine();

                // Listing 10-67. Dodanie kolejnego fragmentu tekstu.
                builder1.Append('B', 12);
                Console.WriteLine(builder1.Capacity);
                Console.WriteLine(builder1.Length);


                Console.WriteLine();

                // Listing 10-68. Dodanie kolejnego fragmentu tekstu
                builder1.Append('C', 30);
                Console.WriteLine(builder1.Capacity);
                Console.WriteLine(builder1.Length);


                Console.WriteLine();

                // Listing 10-69. Zapewnianie odpowiedniej pojemności obiektu StringBuilder
                builder1.EnsureCapacity(32000);
                Console.WriteLine(builder1.Capacity);
                Console.WriteLine(builder1.Length);


                Console.WriteLine();

                // Listing 10-70. Próba zmniejszenia pojemności
                builder1.EnsureCapacity(70);
                Console.WriteLine(builder1.Capacity);
                Console.WriteLine(builder1.Length);
            }
        }
    }
}
